// API endpoint
const API_URL = 'https://jun.quypn.com';

// Lưu trữ thời gian hiển thị cuối cùng
let lastShown = null;
let lastShownDate = null;

// Lưu trữ thông tin về lần hiển thị cuối cùng
chrome.runtime.onInstalled.addListener(() => {
  chrome.storage.sync.set({ 
    lastShown: null,
    lastShownDate: null 
  });
});

// Lắng nghe sự kiện cập nhật tab
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (changeInfo.status === 'complete') {
    checkAndShowMessage(tab);
  }
});

// Kiểm tra và hiển thị tin nhắn
async function checkAndShowMessage(tab) {
  const now = new Date();
  const currentHour = now.getHours();
  const today = now.toDateString();
  
  // Chỉ hiển thị từ 7h sáng
  if (currentHour < 7) return;
  
  // Lấy ngày hiển thị cuối cùng
  const { lastShown, lastShownDate } = await chrome.storage.sync.get(['lastShown', 'lastShownDate']);
  
  // Kiểm tra nếu đã hiển thị hôm nay
  if (lastShownDate === today) return;
  
  try {
    // Gọi API một lần để lấy cả message và background
    const response = await fetch(`${API_URL}/api.php`);
    const data = await response.json();
    
    if (!data.success) {
      console.error('Failed to get data:', data.error);
      return;
    }
    
    setTimeout(async () => {
    // Gửi tin nhắn và background đến content script
      try {
        chrome.tabs.sendMessage(tab.id, {
          action: "showMessage",
          message: data.message,
          background: `${API_URL}${data.image_url}`
        });
        
        // Cập nhật ngày hiển thị
        chrome.storage.sync.set({
          lastShown: data.message,
          lastShownDate: today
        });
      } catch (error) {
        console.error('Error sending message to content script:', error);
        // Thử lại sau 1 giây nếu content script chưa sẵn sàng
        setTimeout(() => {
          chrome.tabs.sendMessage(tab.id, {
            action: "showMessage",
            message: data.message,
            background: `${API_URL}${data.image_url}`
          }).catch(err => console.error('Retry failed:', err));
        }, 1000);
      }
    }, 1000);
    
  } catch (error) {
    console.error('Error fetching data:', error);
  }
} 