// Import background images
const backgroundImages = [
    'images/1.jpg',
    'images/2.jpg',
    'images/3.jpg',
    'images/4.jpg',
    'images/5.jpg',
    'images/6.jpg',
    'images/7.jpg',
    'images/8.jpg',
    'images/9.jpg',
];

// Tạo và thêm style cho thông báo
const style = document.createElement('style');
style.textContent = `
  .daily-message-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 999999998;
    display: flex;
    justify-content: center;
    align-items: center;
    animation: fadeIn 0.5s ease-out;
    background-color: rgba(0, 0, 0, 0.6);
    overflow: hidden;
  }

  .daily-message-overlay::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: var(--background-image);
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    opacity: 0.8;
    z-index: -1;
  }

  .daily-message-container {
    position: absolute;
    background-color: rgba(0, 0, 0, 0.2);
    padding: 40px 50px;
    border-radius: 20px;
    max-width: 780px;
    width: 90%;
    text-align: center;
    font-family: Arial, sans-serif;
    animation: slideUp 0.5s ease-out;
    backdrop-filter: blur(5px);
    bottom: 15%;
    left: 50%;
    transform: translateX(-50%);
  }
  
  @keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
  }
  
  @keyframes slideUp {
    from { 
      transform: translateX(-50%) translateY(100px);
      opacity: 0;
    }
    to { 
      transform: translateX(-50%) translateY(0);
      opacity: 1;
    }
  }
  
  @keyframes slideDown {
    from { 
      transform: translateX(-50%) translateY(0);
      opacity: 1;
    }
    to { 
      transform: translateX(-50%) translateY(100px);
      opacity: 0;
    }
  }
  
  .daily-message-container p {
    margin: 0;
    color: #ffffff;
    font-size: 20px;
    line-height: 1.6;
    font-weight: 500;
    text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
    letter-spacing: 0.5px;
  }
  
  .daily-message-container .close-btn {
    position: absolute;
    top: 15px;
    right: 15px;
    background: rgba(255, 255, 255, 0.2);
    border: none;
    font-size: 24px;
    cursor: pointer;
    color: #ffffff;
    width: 35px;
    height: 35px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    transition: all 0.3s;
    text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5);
  }
  
  .daily-message-container .close-btn:hover {
    background-color: rgba(255, 255, 255, 0.3);
    transform: rotate(90deg);
  }
  
  .daily-message-container .close-btn:active {
    background-color: rgba(255, 255, 255, 0.4);
  }

  .heart {
    position: absolute;
    top: -50px;
    pointer-events: none;
    animation: float linear infinite;
    color: #ff6b6b;
    font-size: 20px;
    text-shadow: 0 0 10px rgba(255, 107, 107, 0.5);
  }

  @keyframes float {
    0% {
      transform: translateY(-50px) translateX(0) rotate(0deg);
      opacity: 0.5;
    }
    10% {
      opacity: 0.9;
    }
    100% {
      transform: translateY(100vh) translateX(var(--random-x)) rotate(360deg);
      opacity: 0;
    }
  }

  .heart::before {
    content: '❤';
    display: block;
  }
`;

document.head.appendChild(style);

// Xử lý tin nhắn từ background script
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  console.log('Nhận được tin nhắn:', request);
  if (request.action === "showMessage") {
    showMessage(request.message, request.background);
  }
  return false;
});

function createHeart(overlay) {
  const heart = document.createElement('div');
  heart.className = 'heart';
  
  // Random size between 15px and 30px
  const size = Math.random() * 15 + 15;
  heart.style.fontSize = `${size}px`;
  
  // Random position
  const startX = Math.random() * window.innerWidth;
  heart.style.left = `${startX}px`;
  
  // Random animation duration between 3s and 6s
  const duration = Math.random() * 3 + 3;
  heart.style.animationDuration = `${duration}s`;
  
  // Random x-axis movement
  const randomX = (Math.random() - 0.5) * 100;
  heart.style.setProperty('--random-x', `${randomX}px`);
  
  overlay.appendChild(heart);
  
  // Remove heart after animation
  setTimeout(() => heart.remove(), duration * 1000);
}

function startHeartEffect(overlay) {
  // Create a heart every 300ms
  const heartInterval = setInterval(() => {
    createHeart(overlay);
  }, 300);
  
  return heartInterval;
}

function showMessage(message, background) {
  console.log('Đang hiển thị tin nhắn:', message);
  // Kiểm tra xem đã có thông báo nào chưa
  if (document.querySelector('.daily-message-overlay')) {
    console.log('Đã có thông báo, bỏ qua');
    return;
  }

  // Tạo overlay
  const overlay = document.createElement('div');
  overlay.className = 'daily-message-overlay';
  overlay.style.setProperty('--background-image', `url(${background})`);

  // Tạo container
  const container = document.createElement('div');
  container.className = 'daily-message-container';
  
  const closeBtn = document.createElement('button');
  closeBtn.className = 'close-btn';
  closeBtn.innerHTML = '×';
  closeBtn.onclick = () => {
    container.style.animation = 'slideDown 0.5s ease-out';
    setTimeout(() => overlay.remove(), 500);
  };
  
  const messageText = document.createElement('p');
  messageText.innerHTML = message.replace(/\n/g, '<br>');
  messageText.style.whiteSpace = 'pre-line';
  
  container.appendChild(closeBtn);
  container.appendChild(messageText);
  overlay.appendChild(container);
  document.body.appendChild(overlay);

  // Bắt đầu hiệu ứng trái tim
  const heartInterval = startHeartEffect(overlay);
  
  // Tự động ẩn sau 10 giây
  setTimeout(() => {
    clearInterval(heartInterval);
    container.style.animation = 'slideDown 0.5s ease-out';
    setTimeout(() => overlay.remove(), 500);
  }, 30 * 1000);
} 